 
  set sql_safe_updates=0;
 
  -- CONSOLIDATED_ATTENDANCE_MISSED_BY_FACULTY
   
SET @consolidated=(SELECT id FROM dtprovider WHERE `dataProviderName`='CONSOLIDATE_ATTENDANCE_MISSED_BY_FACULTY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.facultyId AS ID,
    T1.id AS PLAN_ID,
	DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    T2.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,
    T3.displayName AS ACADEMY_NAME,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
	T5.emailId AS EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.salutationName AS SALUTATION_NAME,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
	date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE,
    ml.code as LANGUAGE_KEY
FROM
    course_coverage_plan T1
        LEFT JOIN
        program_batch_course_param prm on prm.courseVarientId = T1.courseVariantId
        LEFT JOIN
    `prog_batch_period_config` per ON per.id = prm.progBatchPeriodConfigId        
        LEFT JOIN
    course_variants T2 ON T2.id = T1.courseVariantId
        LEFT JOIN
    academy_location T3 ON T3.id = T1.academyLocationId
        LEFT JOIN
    staffs T4 ON T4.userId = T1.facultyId
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
   	    LEFT join
    salutations T6 ON T6.id = T5.salutationId
		LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
    T1.facultyId IN (namedParams)
    AND per.isCurrentPeriodOfProgram = TRUE
    AND T1.studentCourseAttendanceId is null
    AND T1.whetherDeleted = false
	AND T1.sessionDate <= DATE(NOW())" WHERE `dataProviderId`=@consolidated;   
	
    -- CONSOLIDATED_ATTENDANCE_MISSED_BY_TEACHER
   
SET @consolidated=(SELECT id FROM dtprovider WHERE `dataProviderName`='CONSOLIDATE_ATTENDANCE_MISSED_BY_TEACHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    CONCAT(IFNULL(prsn.firstName, ''),
            ' ',
            IFNULL(prsn.lastName, '')) AS FIRST_NAME,
    s.facultyId AS ID,
    td.trans_date AS SESSION_DATE,
    pgrm.programName AS PROGRAM_NAME,
    s.sectionCode AS SECTION_CODE,
    al.displayName AS ACADEMY_NAME,
    prsn.emailId AS EMAIL_ID,
    prsn.mobileNumber AS MOBILE_NO,
    prsn.mobileCountryCode AS MOBILE_CODE,
	ml.code as LANGUAGE_KEY
FROM
    sections AS s
        JOIN
    prog_batch_period_config AS pbp ON (s.periodId = pbp.id
        AND pbp.isCurrentPeriodOfProgram = 1)
        JOIN
    batches AS b ON (b.id = pbp.programBatchId)
        JOIN
    programs AS pgrm ON pgrm.id = b.programId
        JOIN
    academy_location al ON al.id = pgrm.academyLocationId
        JOIN
    staffs AS st ON st.userId = s.facultyId
        JOIN
    persons prsn ON prsn.id = st.personId
        JOIN
    time_dimension AS td ON ((td.trans_date BETWEEN pbp.programPeriodStart AND pbp.programPeriodEnd)
        AND td.trans_date <= CURRENT_DATE()
        AND pbp.programPeriodEnd >= CURRENT_DATE())
        JOIN
    calendar_working_weekdays AS cww ON cww.calendarId = b.calendarId
        JOIN
    calendar_weekdays AS cw ON cww.calendarWeekdayId = cw.id
        AND cw.weekDay = td.day_name
        LEFT JOIN
    student_program_attendance AS spa ON s.id = spa.sectionId
        AND s.facultyId = spa.facultyId
        AND spa.dateOfAttendance = td.trans_date
        AND spa.attendanceType = 'COMPLETE_DAY'
        LEFT JOIN
    (SELECT 
        calendar_holidays.calendarId,
            calendar_holidays.fromDate,
            calendar_holidays.toDate,
            time_dimension.trans_date
    FROM
        time_dimension
    JOIN calendar_holidays ON trans_date BETWEEN fromDate AND toDate
        AND time_dimension.trans_date < CURRENT_DATE()
    GROUP BY trans_date , calendarId) AS cal_holi ON td.trans_date = cal_holi.trans_date
        AND cal_holi.calendarId = b.calendarId
        LEFT JOIN
	multi_language ml on ml.id=prsn.correspondence_language
WHERE
    spa.id IS NULL
        AND td.trans_date <= CURRENT_DATE()
        AND cal_holi.trans_date IS NULL
        AND st.userId IN (namedParams)" WHERE `dataProviderId`=@consolidated;  	      
        
   -- EMPLOYEE_LEAVE_CREATE
   
SET @employeeLeave=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_CREATE_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    approver.printName AS PRINT_NAME,
    approver.firstName AS FIRST_NAME,
    approver.middleName AS MIDDLE_NAME,
    approver.lastName AS LAST_NAME,
    approver.emailId AS EMAIL_ID,
    approver.mobileNumber AS MOBILE_NO,
    approver.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS REQUESTER_PRINT_NAME,
    requester.firstName AS REQUESTER_FIRST_NAME,
    requester.lastName AS REQUESTER_LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T5.leaveCode AS LEAVE_CODE,
    T5.leaveType AS LEAVE_TYPE,
    T5.eligibilityCriteria AS ELIGIBILITY_CRITERIA,
    T2.reason AS REASON,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.id AS ACADEMY_LOCATION_ID,
    DATE_FORMAT(T2.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T2.toDate, '%d-%m-%Y') AS TO_DATE,
    ml.code as LANGUAGE_KEY
FROM
    hr_emp_leave_request_detail AS T1
        INNER JOIN
    hr_emp_leave_request AS T2 ON T2.id = T1.empLeaveRequestId
        INNER JOIN
    staffs AS T3 ON T3.userId = T1.approverId
        INNER JOIN
    staffs AS T4 ON T4.userId = T2.requestUserId
        INNER JOIN
    persons AS approver ON approver.id = T3.personId
        INNER JOIN
    persons AS requester ON requester.id = T4.personId
        INNER JOIN
    users AS reqUser ON reqUser.id = T4.userId
        LEFT JOIN
    hr_leave_type AS T5 ON T5.id = T2.hrLeaveTypeId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
		LEFT JOIN
	multi_language ml on ml.id=approver.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@employeeLeave;  
 
 
    -- EMPLOYEE_LEAVE_REJECT
   
SET @employeeLeaveReject=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_REJECT_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    requester.emailId AS EMAIL_ID,
    requester.mobileNumber AS MOBILE_NO,
    requester.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS PRINT_NAME,
    requester.firstName AS FIRST_NAME,
    requester.lastName AS LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T5.salutationName AS SALUTATION_NAME,
    T2.comment AS REASON,
    approver.printName AS REJECTER_PRINT_NAME,
    approver.firstName AS REJECTER_FIRST_NAME,
    approver.middleName AS REJECTER_MIDDLE_NAME,
    approver.lastName AS REJECTER_LAST_NAME,
    T6.academyName AS ACADEMY_NAME,
	T6.locationName AS LOCATION_NAME,
	T6.displayName AS ACADEMY_NAME_LOCATION,
	T6.id AS ACADEMY_LOCATION_ID, 
    DATE_FORMAT(T1.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.toDate, '%d-%m-%Y') AS TO_DATE,
    ml.code as LANGUAGE_KEY
FROM
    hr_emp_leave_request AS T1
        INNER JOIN
    hr_emp_leave_request_detail AS T2 ON T2.empLeaveRequestId = T1.id
        INNER JOIN
    staffs AS T3 ON T3.userId = T1.requestUserId
        INNER JOIN
    persons AS requester ON requester.id = T3.personId
        INNER JOIN
    users AS reqUser ON reqUser.id = T3.userId
        INNER JOIN
    staffs AS T4 ON T4.userId = T2.approverId
        INNER JOIN
    persons AS approver ON approver.id = T4.personId
        LEFT JOIN
    salutations AS T5 ON T5.id = requester.salutationId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
	multi_language ml on ml.id=requester.correspondence_language
WHERE
    T1.id IN (namedParams) AND T1.status = 'REJECTED' AND T2.status = 'REJECTED'" WHERE `dataProviderId`=@employeeLeaveReject;  
 
 
     -- EMPLOYEE_LEAVE_WITHDRAWN
   
SET @employeeLeaveWin=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_WITHDRAWN_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    requester.emailId AS EMAIL_ID,
    requester.mobileNumber AS MOBILE_NO,
    requester.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS PRINT_NAME,
    requester.firstName AS FIRST_NAME,
    requester.lastName AS LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T5.salutationName AS SALUTATION_NAME,
    T6.academyName AS ACADEMY_NAME,
	T6.locationName AS LOCATION_NAME,
	T6.displayName AS ACADEMY_NAME_LOCATION,
	T6.id AS ACADEMY_LOCATION_ID, 
    DATE_FORMAT(T1.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.toDate, '%d-%m-%Y') AS TO_DATE,
     ml.code as LANGUAGE_KEY
FROM
    hr_emp_leave_request AS T1
       INNER JOIN
    staffs AS T3 ON T3.userId = T1.requestUserId
        INNER JOIN
    persons AS requester ON requester.id = T3.personId
        LEFT JOIN
    salutations AS T5 ON T5.id = requester.salutationId
		INNER JOIN
    users AS reqUser ON reqUser.id = T3.userId
    	 LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
	multi_language ml on ml.id=requester.correspondence_language
WHERE
    T1.id IN (namedParams) AND T1.status = 'WITHDRAWN'" WHERE `dataProviderId`=@employeeLeaveWin; 
    
 
     -- EMPLOYEE_LEAVE_REQUESTER_APPROVE
   
SET @employeeLeaveReqApro=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_REQUESTER_APPROVE_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T6.id AS ID,
    requester.emailId AS EMAIL_ID,
    requester.mobileNumber AS MOBILE_NO,
    requester.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS PRINT_NAME,
    requester.firstName AS FIRST_NAME,
    requester.lastName AS LAST_NAME,
    aprover.printName AS APPROVER_PRINT_NAME,
    aprover.firstName AS APPROVER_FIRST_NAME,
    aprover.lastName AS APPROVER_LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T5.salutationName AS SALUTATION_NAME,
    T8.academyName AS ACADEMY_NAME,
	T8.locationName AS LOCATION_NAME,
	T8.displayName AS ACADEMY_NAME_LOCATION,
	T8.id AS ACADEMY_LOCATION_ID,
    DATE_FORMAT(T1.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.toDate, '%d-%m-%Y') AS TO_DATE,
    ml.code as LANGUAGE_KEY
FROM
    hr_emp_leave_request_detail AS T6
        LEFT JOIN
    hr_emp_leave_request AS T1 ON T1.id = T6.empLeaveRequestId
        LEFT JOIN
    staffs AS T3 ON T3.userId = T1.requestUserId
        LEFT JOIN
    persons AS requester ON requester.id = T3.personId
        LEFT JOIN
    salutations AS T5 ON T5.id = requester.salutationId
        LEFT JOIN
    users AS reqUser ON reqUser.id = T3.userId
        LEFT JOIN
    staffs AS T7 ON T7.userId = T6.approverId
        LEFT JOIN
    persons AS aprover ON aprover.id = T7.personId
	 LEFT JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
	multi_language ml on ml.id=requester.correspondence_language
WHERE
    T6.id IN (namedParams) AND T6.status = 'APPROVED'" WHERE `dataProviderId`=@employeeLeaveReqApro; 
    
      -- EMPLOYEE_LEAVE_APPROVER_APPROVE
   
SET @employeeLeaveAproApro=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_APPROVER_APPROVE_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    aprover.emailId AS EMAIL_ID,
    aprover.mobileNumber AS MOBILE_NO,
    aprover.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS REQUESTER_PRINT_NAME,
    requester.firstName AS REQUESTER_FIRST_NAME,
    requester.lastName AS REQUESTER_LAST_NAME,
    aprover.printName AS PRINT_NAME,
    aprover.firstName AS FIRST_NAME,
    aprover.lastName AS LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T1.reason AS REASON,
    T5.salutationName AS SALUTATION_NAME,
    T8.eligibilityCriteria AS ELIGIBILITY_CRITERIA,
    T8.leaveCode As LEAVE_CODE,
	T8.leaveType As LEAVE_TYPE,
    T9.academyName AS ACADEMY_NAME,
	T9.locationName AS LOCATION_NAME,
	T9.displayName AS ACADEMY_NAME_LOCATION,
	T9.id AS ACADEMY_LOCATION_ID, 
    DATE_FORMAT(T1.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.toDate, '%d-%m-%Y') AS TO_DATE,
    ml.code as LANGUAGE_KEY
FROM
    hr_emp_leave_request AS T1
        LEFT JOIN
    hr_emp_leave_request_detail AS T6 ON T6.empLeaveRequestId = T1.id
        LEFT JOIN
    staffs AS T3 ON T3.userId = T1.requestUserId
        LEFT JOIN
    persons AS requester ON requester.id = T3.personId
       LEFT JOIN
    users AS reqUser ON reqUser.id = T3.userId
        LEFT JOIN
    staffs AS T7 ON T7.userId = T6.approverId
        LEFT JOIN
    persons AS aprover ON aprover.id = T7.personId
 		LEFT JOIN
    salutations AS T5 ON T5.id = aprover.salutationId
		LEFT JOIN
    hr_leave_type as T8 on T8.id  = T1.hrLeaveTypeId 
     LEFT JOIN
    academy_location T9 ON T9.id = T1.academyLocationId
        LEFT JOIN
	multi_language ml on ml.id=aprover.correspondence_language
WHERE
    T1.id IN (namedParams) AND T6.status = 'PENDING' and T6.approverLevelId = (select MIN(approverLevelId) from hr_emp_leave_request_detail where empLeaveRequestId IN (namedParams) and status = 'pending')" WHERE `dataProviderId`=@employeeLeaveAproApro; 
    
       -- EMPLOYEE_LEAVE_REQUEST_ESCALATION_REQUESTER
   
SET @employeeLeaveReqEscaReq=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_ESCALETED_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T6.id AS ID,
    requester.emailId AS EMAIL_ID,
    requester.mobileNumber AS MOBILE_NO,
    requester.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS PRINT_NAME,
    requester.firstName AS FIRST_NAME,
    requester.lastName AS LAST_NAME,
    aprover.printName AS APPROVER_PRINT_NAME,
    aprover.firstName AS APPROVER_FIRST_NAME,
    aprover.lastName AS APPROVER_LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T5.salutationName AS SALUTATION_NAME,
    T8.academyName AS ACADEMY_NAME,
	T8.locationName AS LOCATION_NAME,
	T8.displayName AS ACADEMY_NAME_LOCATION,
	T8.id AS ACADEMY_LOCATION_ID,
    DATE_FORMAT(T1.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.toDate, '%d-%m-%Y') AS TO_DATE,
    ml.code as LANGUAGE_KEY
FROM
    hr_emp_leave_request_detail AS T6
        LEFT JOIN
    hr_emp_leave_request AS T1 ON T1.id = T6.empLeaveRequestId
        LEFT JOIN
    staffs AS T3 ON T3.userId = T1.requestUserId
        LEFT JOIN
    persons AS requester ON requester.id = T3.personId
        LEFT JOIN
    salutations AS T5 ON T5.id = requester.salutationId
        LEFT JOIN
    users AS reqUser ON reqUser.id = T3.userId
        LEFT JOIN
    staffs AS T7 ON T7.userId = T6.approverId
        LEFT JOIN
    persons AS aprover ON aprover.id = T7.personId
	 LEFT JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
	multi_language ml on ml.id=requester.correspondence_language
WHERE
    T6.id IN (namedParams) AND T6.status = 'ESCALATED'" WHERE `dataProviderId`=@employeeLeaveReqEscaReq;
 
        -- EMPLOYEE_LEAVE_REQUEST_ESCALATION_APPROVER
   
SET @employeeLeaveReqEscaApro=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_ESCALETED_APPROVER_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    approver.printName AS PRINT_NAME,
    approver.firstName AS FIRST_NAME,
    approver.middleName AS MIDDLE_NAME,
    approver.lastName AS LAST_NAME,
    approver.emailId AS EMAIL_ID,
    approver.mobileNumber AS MOBILE_NO,
    approver.mobileCountryCode AS MOBILE_CODE,
    T7.salutationName AS SALUTATION_NAME,
    requester.printName AS REQUESTER_PRINT_NAME,
    requester.firstName AS REQUESTER_FIRST_NAME,
    requester.lastName AS REQUESTER_LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T5.leaveCode AS LEAVE_CODE,
	T5.leaveType As LEAVE_TYPE,
    T5.eligibilityCriteria AS ELIGIBILITY_CRITERIA,
    T2.reason AS REASON,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.id AS ACADEMY_LOCATION_ID,
    DATE_FORMAT(T2.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T2.toDate, '%d-%m-%Y') AS TO_DATE,
    ml.code as LANGUAGE_KEY
FROM
    hr_emp_leave_request_detail AS T1
        INNER JOIN
    hr_emp_leave_request AS T2 ON T2.id = T1.empLeaveRequestId
        INNER JOIN
    staffs AS T3 ON T3.userId = T1.approverId
        INNER JOIN
    staffs AS T4 ON T4.userId = T2.requestUserId
        INNER JOIN
    persons AS approver ON approver.id = T3.personId
        INNER JOIN
    persons AS requester ON requester.id = T4.personId
        INNER JOIN
    users AS reqUser ON reqUser.id = T4.userId
        LEFT JOIN
    hr_leave_type AS T5 ON T5.id = T2.hrLeaveTypeId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
		LEFT JOIN
    salutations AS T7 ON T7.id = approver.salutationId
        LEFT JOIN
	multi_language ml on ml.id=approver.correspondence_language
WHERE
    T1.id IN (namedParams) AND T1.status = 'PENDING'" WHERE `dataProviderId`=@employeeLeaveReqEscaApro;
            

        -- SERVICE_REQUEST_STUDENT_CREATION
   
SET @srStudentCreation=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_STUDENT_CREATION_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
	T1.requestId AS REQUEST_ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T2.requestType AS REQUEST_TYPE,
    ml.code as LANGUAGE_KEY
FROM
    service_requests T1
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
        LEFT JOIN
    users T3 ON T3.id = T1.requester
        LEFT JOIN
    students T4 ON T4.userId = T3.id
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
        LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@srStudentCreation; 
    
        -- SERVICE_REQUEST_ASSINEE_CREATION
   
SET @srStudentAssigneeCreation=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_ASSINEE_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
	T1.requestId AS REQUEST_ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T2.requestType AS REQUEST_TYPE,
	ml.code as LANGUAGE_KEY
FROM
    service_requests T1
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
        LEFT JOIN
    users T3 ON T3.id = T1.assigneeId
        LEFT JOIN
    staffs T4 ON T4.userId = T3.id
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
        LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@srStudentAssigneeCreation;  
    
        -- SERVICE_REQUEST_FOLLOWUP_ASSIGN
   
SET @srFollowUpAssignee=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_FOLLOWUP_ASSIGN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T7.id AS ID,
    T1.requestId AS REQUEST_ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T2.requestType AS REQUEST_TYPE,
    ml.code as LANGUAGE_KEY
FROM
    followup_details T7
        LEFT JOIN
    service_requests T1 ON T1.id = T7.serviceRequestId
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
        LEFT JOIN
    users T3 ON T3.id = T7.assigneeUserId
        LEFT JOIN
    staffs T4 ON T4.userId = T3.id
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
        LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
    T7.id IN (namedParams)" WHERE `dataProviderId`=@srFollowUpAssignee;     
            
 
  -- SERVICE_REQUEST_PARENT_CREATION
   
SET @srParentCreation=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_PARENT_CREATION_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
	T1.requestId AS REQUEST_ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T2.requestType AS REQUEST_TYPE,
    ml.code as LANGUAGE_KEY
FROM
    service_requests T1
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
        LEFT JOIN
    users T3 ON T3.id = T1.parentsId
        LEFT JOIN
    parents T4 ON T4.userId = T3.id
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
        LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@srParentCreation;       
 
  
  -- Event Reminder-One Date Prior
   
SET @eventReminderOne=(SELECT id FROM dtprovider WHERE `dataProviderName`='EVENT_REMINDER_PRIOR_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    rbu.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    rb.eventName AS EVENT_NAME,
    rb.venue AS VENUE,
    rb.eventDesc AS EVENT_DESC,
    DATE_FORMAT(rb.eventDate,'%d-%m-%Y') as EVENT_DATE, 
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    resource_bookings rb
        JOIN
    resource_booking_users rbu ON rbu.resourceBookingId = rb.id
        JOIN
    staffs s ON s.userId = rbu.userId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
        LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE
    rbu.id in (namedParams)
GROUP BY rbu.id
UNION
SELECT 
    rbu.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    rb.eventName AS EVENT_NAME,
    rb.venue AS VENUE,
    rb.eventDesc AS EVENT_DESC,
    DATE_FORMAT(rb.eventDate,'%d-%m-%Y') as EVENT_DATE, 
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    resource_bookings rb
        JOIN
    resource_booking_users rbu ON rbu.resourceBookingId = rb.id
        JOIN
    students st ON st.userId = rbu.studentId
        JOIN
    persons p ON p.id = st.personId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = st.userId
        LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE
    rbu.id in (namedParams)
GROUP BY rbu.id" WHERE `dataProviderId`=@eventReminderOne;       
            
   -- Event Reminder-On Date
   
SET @eventReminderOnDate=(SELECT id FROM dtprovider WHERE `dataProviderName`='EVENT_REMINDER_ON_DATE_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    rbu.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    rb.eventName AS EVENT_NAME,
    rb.venue AS VENUE,
    rb.eventDesc AS EVENT_DESC,
    DATE_FORMAT(rb.eventDate,'%d-%m-%Y') as EVENT_DATE, 
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    resource_bookings rb
        JOIN
    resource_booking_users rbu ON rbu.resourceBookingId = rb.id
        JOIN
    staffs s ON s.userId = rbu.userId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
WHERE
    rbu.id in (namedParams)
GROUP BY rbu.id
UNION
SELECT 
    rbu.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    rb.eventName AS EVENT_NAME,
    rb.venue AS VENUE,
    rb.eventDesc AS EVENT_DESC,
    DATE_FORMAT(rb.eventDate,'%d-%m-%Y') as EVENT_DATE, 
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    resource_bookings rb
        JOIN
    resource_booking_users rbu ON rbu.resourceBookingId = rb.id
        JOIN
    students st ON st.userId = rbu.studentId
        JOIN
    persons p ON p.id = st.personId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = st.userId
        LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE
    rbu.id in (namedParams)
GROUP BY rbu.id" WHERE `dataProviderId`=@eventReminderOnDate; 
 
   -- POSITIVE_INCIDENT_PARENT_GUARDIAN1
   
SET @positiveIncidentPrntGrdn=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_PARENT_GUARDIAN1_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
        LEFT JOIN
    persons AS T10 ON T10.id = T4.personId
        LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'POSITIVE' and T8.relationship = 'FATHER'" WHERE `dataProviderId`=@positiveIncidentPrntGrdn; 
 
 
    -- NEGATIVE_INCIDENT_PARENT_GUARDIAN1
   
SET @nigeitiveIncidentPrntGrdn=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_PARENT_GUARDIAN1_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
        LEFT JOIN
    persons AS T10 ON T10.id = T4.personId
        LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'NEGATIVE' and T8.relationship = 'FATHER'" WHERE `dataProviderId`=@nigeitiveIncidentPrntGrdn; 
 
 
     -- POSITIVE_INCIDENT_PARENT_GUARDIAN2
   
SET @positiveIncidentPrntGrdn2=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_PARENT_GUARDIAN2_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
            LEFT JOIN
    persons AS T10 ON T10.id = T4.personId
        LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'POSITIVE' and T8.relationship = 'MOTHER'" WHERE `dataProviderId`=@positiveIncidentPrntGrdn2;
        
     -- NEGATIVE_INCIDENT_PARENT_GUARDIAN2
   
SET @nigeitiveIncidentPrntGrdn2=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_PARENT_GUARDIAN2_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
		LEFT JOIN
    persons AS T10 ON T10.id = T4.personId
        LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'NEGATIVE' and T8.relationship = 'MOTHER'" WHERE `dataProviderId`=@nigeitiveIncidentPrntGrdn2;        


     -- POSITIVE_INCIDENT_LOCAL_GUARDIAN
   
SET @positiveIncidentLocalGrdn=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_LOCAL_GUARDIAN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
    	LEFT JOIN
    persons AS T10 ON T10.id = T4.personId
        LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'POSITIVE' and T8.relationship = 'LOCAL_GUARDIAN'" WHERE `dataProviderId`=@positiveIncidentLocalGrdn;

-- NEGATIVE_INCIDENT_LOCAL_GUARDIAN
   
SET @negativeIncidentLocalGrdn=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_LOCAL_GUARDIAN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
    	LEFT JOIN
    persons AS T10 ON T10.id = T4.personId
        LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'NEGATIVE' and T8.relationship = 'LOCAL_GUARDIAN'" WHERE `dataProviderId`=@negativeIncidentLocalGrdn;
 
 
 -- POSITIVE_INCIDENT_ALOWNER
   
SET @positiveIncidentALOwner=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_ALOWNER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        LEFT OUTER JOIN
    users T8 ON T7.ownerId = T8.id
        INNER JOIN
    staffs T9 ON T9.userId = T8.id
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
     LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
        LEFT JOIN
    multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'POSITIVE'
        AND T7.purposeCode = 'COURSE_EXECUTION'" WHERE `dataProviderId`=@positiveIncidentALOwner;
        
 
 -- NEGATIVE_INCIDENT_ALOWNER
   
SET @negativeIncidentALOwner=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_ALOWNER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        LEFT OUTER JOIN
    users T8 ON T7.ownerId = T8.id
        INNER JOIN
    staffs T9 ON T9.userId = T8.id
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
        LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
        LEFT JOIN
    multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'NEGATIVE'
        AND T7.purposeCode = 'COURSE_EXECUTION'" WHERE `dataProviderId`=@negativeIncidentALOwner;        
 
 -- POSITIVE_INCIDENT_PRINCIPLE
   
SET @PositiveIncidentPrinciple=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_PRINCIPLE_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    program_batch_students pbs ON pbs.admissionId = T5.id
        inner JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    batches b ON b.id = pbs.programBatchId
        LEFT JOIN
    programs p ON p.id = b.programId
        LEFT JOIN
    program_group pg ON pg.id = p.programGroupId
        LEFT JOIN
    program_group_details pgd ON pgd.programGroupId = pg.id and pgd.academyLocationId = T5.academyLocationId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        left JOIN
    staffs T9 ON T9.userId = pgd.principalId
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
        LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
        LEFT JOIN
    multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
       AND T2.category = 'POSITIVE'
        AND pbs.isCurrentSection = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL" WHERE `dataProviderId`=@PositiveIncidentPrinciple;  
 
 
  -- NEGATIVE_INCIDENT_PRINCIPLE
   
SET @negativeIncidentPrinciple=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_PRINCIPLE_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    program_batch_students pbs ON pbs.admissionId = T5.id
        inner JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    batches b ON b.id = pbs.programBatchId
        LEFT JOIN
    programs p ON p.id = b.programId
        LEFT JOIN
    program_group pg ON pg.id = p.programGroupId
        LEFT JOIN
    program_group_details pgd ON pgd.programGroupId = pg.id and pgd.academyLocationId = T5.academyLocationId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        left JOIN
    staffs T9 ON T9.userId = pgd.principalId
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
        LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
        LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
       AND T2.category = 'NEGATIVE'
        AND pbs.isCurrentSection = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL" WHERE `dataProviderId`=@negativeIncidentPrinciple; 
 
   -- NEGATIVE_INCIDENT_PRINCIPLE
   
SET @negativeIncidentPrinciple=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_PRINCIPLE_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    program_batch_students pbs ON pbs.admissionId = T5.id
        inner JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    batches b ON b.id = pbs.programBatchId
        LEFT JOIN
    programs p ON p.id = b.programId
        LEFT JOIN
    program_group pg ON pg.id = p.programGroupId
        LEFT JOIN
    program_group_details pgd ON pgd.programGroupId = pg.id and pgd.academyLocationId = T5.academyLocationId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        left JOIN
    staffs T9 ON T9.userId = pgd.principalId
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
        LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
        LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
       AND T2.category = 'NEGATIVE'
        AND pbs.isCurrentSection = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL" WHERE `dataProviderId`=@negativeIncidentPrinciple; 
 
    -- POSITIVE_INCIDENT_CLASSTEACHER
   
SET @positivetiveIncidentTeach=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_CLASSTEACHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    program_batch_students pbs ON pbs.admissionId = T5.id
        inner JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        Inner JOIN
    staffs T9 ON T9.userId = sec.facultyId
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
        LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
	    LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
		AND T2.category = 'POSITIVE'
        AND pbs.isCurrentSection = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL" WHERE `dataProviderId`=@positivetiveIncidentTeach; 

    -- NEGATIVE_INCIDENT_CLASSTEACHER
   
SET @negativetiveIncidentTeach=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_CLASTEACHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    program_batch_students pbs ON pbs.admissionId = T5.id
        inner JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        Inner JOIN
    staffs T9 ON T9.userId = sec.facultyId
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
        LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
        LEFT JOIN
	multi_language ml on ml.id=T10.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
		AND T2.category = 'NEGATIVE'
        AND pbs.isCurrentSection = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL" WHERE `dataProviderId`=@negativetiveIncidentTeach; 
 
 -- EMPLOYEE_LEAVE_CANCELLED
   
SET @employeeLeaveCncl=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_CANCELLED_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    requester.emailId AS EMAIL_ID,
    requester.mobileNumber AS MOBILE_NO,
    requester.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS PRINT_NAME,
    requester.firstName AS FIRST_NAME,
    requester.lastName AS LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T5.salutationName AS SALUTATION_NAME,
    T2.comment AS REASON,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.id AS ACADEMY_LOCATION_ID,
    DATE_FORMAT(T1.cancelFrom, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.cancelTo, '%d-%m-%Y') AS TO_DATE,
    ml.code as LANGUAGE_KEY
FROM
    hr_emp_leave_request AS T1
        LEFT JOIN
    hr_emp_leave_request_detail AS T2 ON T2.empLeaveRequestId = T1.id
        INNER JOIN
    staffs AS T3 ON T3.userId = T1.requestUserId
        INNER JOIN
    persons AS requester ON requester.id = T3.personId
        LEFT JOIN
    users AS reqUser ON reqUser.id = T3.userId
        LEFT JOIN
    staffs AS T4 ON T4.userId = T2.approverId
        LEFT JOIN
    persons AS approver ON approver.id = T4.personId
        LEFT JOIN
    salutations AS T5 ON T5.id = requester.salutationId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
    LEFT JOIN
	multi_language ml on ml.id=requester.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T1.status IN ('CANCELLED' , 'PARTIALLY CANCELLED','PARTIALLYCANCELLED')
GROUP BY T1.id" WHERE `dataProviderId`=@employeeLeaveCncl; 


 -- SERVICE_REQUEST_APPROVER
   
SET @srApprover=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_APPROVER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    fd.id AS ID,
	T1.requestId AS REQUEST_ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T2.requestType AS REQUEST_TYPE,
    ml.code as LANGUAGE_KEY
FROM
    service_requests T1
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
		LEFT JOIN
	followup_details fd on fd.serviceRequestId = T1.id
        LEFT JOIN
    users T3 ON T3.id = fd.approverUserId
        LEFT JOIN
    staffs T4 ON T4.userId = T3.id
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
    fd.id IN (namedParams)" WHERE `dataProviderId`=@srApprover; 

 -- SERVICE_REQUEST_ESCALATE
   
SET @srEscalate=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_ESCALATE_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    ad.id AS ID,
	T1.requestId AS REQUEST_ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T2.requestType AS REQUEST_TYPE,
    ml.code as LANGUAGE_KEY
FROM
    service_requests T1
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
		LEFT JOIN
	approval_details ad on ad.serviceRequestId = T1.id
        LEFT JOIN
    users T3 ON T3.id = ad.escalatedApproverUserId
        LEFT JOIN
    staffs T4 ON T4.userId = T3.id
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T2.academyLocationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
    ad.id IN (namedParams)" WHERE `dataProviderId`=@srEscalate; 

 -- DAILYENQADMAPPCOUNT
   
SET @dailyEnqMapCount=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILYENQADMAPPCOUNT_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT DISTINCT
	id as ID,
    emailId AS EMAIL_ID,
    mobileNumber AS MOBILE_NO,
    mobileCountryCode as MOBILE_CODE,
    printName as PRINT_NAME,
    firstName as FIRST_NAME,
    lastName as LAST_NAME,
    salutationName AS SALUTATION_NAME,
    displayName as ACADEMY_NAME_LOCATION,
    code as LANGUAGE_KEY,
    DATE_FORMAT(NOW(), '%d-%m-%Y') AS TODAY_DATE,
    SUM(IFNULL(Admissions, 0)) AS Admissions,
    SUM(IFNULL(Application, 0)) AS Application,
    SUM(IFNULL(Enquiry, 0)) AS Enquiry
FROM
    (SELECT 
        (CASE
                WHEN typeName = 'Admission' THEN Count
            END) AS Admissions,
            (CASE
                WHEN typeName = 'Application' THEN Count
            END) AS Application,
            (CASE
                WHEN typeName = 'Enquiry' THEN Count
            END) AS Enquiry,
            p.emailId,
            p.mobileNumber,
            p.mobileCountryCode,
            p.printName,
            p.firstName,
            p.lastName,
            al.displayName,
            a.currentDate,
            al.id,
            sal.salutationName,
            ml.code
    FROM
        (SELECT 
        COUNT(1) AS Count,
            'Admission' AS typeName,
            ap.academyLocationId,a.applicationCreatedOn as currentDate
    FROM
    application a
        join application_program ap on ap.applicationId = a.id -- admission confirmed count
    WHERE
        DATE(a.applicationCreatedOn) = date(now())
            AND ap.academyLocationId in (namedParams) and ap.currentStatus = 'ADMITTED' group by ap.academyLocationId
            UNION SELECT  
        COUNT(1) AS Count,
            'Application' AS typeName,
            ap.academyLocationId,a.applicationCreatedOn as currentDate
            
    FROM
        application a
        join application_program ap on ap.applicationId = a.id  -- application count
    WHERE
        ap.academyLocationId in (namedParams)
            AND a.applicationCreatedOn = date(now()) group by ap.academyLocationId 
            UNION 
            SELECT COUNT(1) AS Count, 'Enquiry' AS typeName,aed.academyLocationId,e.enquiryDate as currentDate
    FROM
    enquiry e
    join enq_student_details esd on esd.enquiryId = e.id
      join admission_enq_details aed on aed.enqStudentDetailsId = esd.id -- enquiry count
    WHERE
        aed.academyLocationId in (namedParams)
            AND e.enquiryDate = date(now())
            group by aed.academyLocationId
            ) AS a
    left JOIN academy_location_purpose alp ON alp.academyLocationId = a.academyLocationId and alp.purposeCode = 'COURSE_EXECUTION'
    JOIN users usr ON usr.id = alp.ownerId
    JOIN staffs s ON s.userId = usr.id
    JOIN persons p ON p.id = s.personId
    left join salutations sal on sal.id = p.salutationId
    LEFT JOIN academy_location al ON al.id = alp.academyLocationId
    LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
    ) AS AA
    group by AA.id" WHERE `dataProviderId`=@dailyEnqMapCount; 
 
  -- ITEM_RECEIVED_NOTIFICATION
   
SET @itemRcvdNtftn=(SELECT id FROM dtprovider WHERE `dataProviderName`='ITEM_RECEIVED_NOTIFICATION_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    T1.inwardNo AS INWARD_NO,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.id AS ACADEMY_LOCATION_ID,
    T4.inventoryType AS INVENTORY_TYPE,
    T7.printName AS ENTRY_BY_PRINT_NAME,
    T7.firstName AS ENTRY_BY_FIRST_NAME,
    T7.lastName AS ENTRY_BY_LAST_NAME,
    DATE_FORMAT(T1.acknowledgmentDate, '%d-%m-%Y') AS ACKNOWLEDGMENT_DATE,
	DATE_FORMAT(T1.deliveryDate, '%d-%m-%Y') AS DELIVERY_DATE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    fd_management_items AS T1
        INNER JOIN
    users AS T2 ON T2.id = T1.receiverId
        INNER JOIN
    staffs T3 ON T3.userId = T2.id
        INNER JOIN
    persons p ON p.id = T3.personId
        LEFT JOIN
    invt_type_master T4 ON T4.id = T1.itemCategoryId
        LEFT JOIN
    staffs T5 ON T5.userId = T1.entryBy
        LEFT JOIN
    persons T7 ON T7.id = T5.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T3.userId
    LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE
    T1.id IN (namedParams)
GROUP BY T1.id
UNION
SELECT 
    T1.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    T1.inwardNo AS INWARD_NO,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.id AS ACADEMY_LOCATION_ID,
    T4.inventoryType AS INVENTORY_TYPE,
    T7.printName AS ENTRY_BY_PRINT_NAME,
    T7.firstName AS ENTRY_BY_FIRST_NAME,
    T7.lastName AS ENTRY_BY_LAST_NAME,
    DATE_FORMAT(T1.acknowledgmentDate, '%d-%m-%Y') AS ACKNOWLEDGMENT_DATE,
	DATE_FORMAT(T1.deliveryDate, '%d-%m-%Y') AS DELIVERY_DATE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    fd_management_items AS T1
        INNER JOIN
    users AS T2 ON T2.id = T1.receiverId
        INNER JOIN
    students T3 ON T3.userId = T2.id
        INNER JOIN
    persons p ON p.id = T3.personId
        LEFT JOIN
    invt_type_master T4 ON T4.id = T1.itemCategoryId
        LEFT JOIN
    staffs T5 ON T5.userId = T1.entryBy
        LEFT JOIN
    persons T7 ON T7.id = T5.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T3.userId
    LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE
    T1.id IN (namedParams)
GROUP BY T1.id" WHERE `dataProviderId`=@itemRcvdNtftn; 

  -- PERSON_TO_MEET_APPOINTMENT
   
SET @personToMeetApp=(SELECT id FROM dtprovider WHERE `dataProviderName`='PERSON_TO_MEET_APPOINTMENT_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.emailId AS EMAIL_ID,
    T3.mobileCountryCode AS MOBILE_CODE,
    T3.mobileNumber AS MOBILE_NO,
    T3.firstName AS FIRST_NAME,
    T3.lastName AS LAST_NAME,
    T3.printName AS PRINT_NAME,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.expectedOutTime, '%h:%i %p') AS OUT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    ent.printName AS CREATED_PRINT_NAME,
    ent.firstName AS CREATED_FIRST_NAME,
    ent.lastName AS CREATED_LAST_NAME,
	TRIM(substring_index(appointeeName, '/', -1)) AS APPOINTEE_NAME,
    ml.code as LANGUAGE_KEY
FROM
    `sg_appointment` T1
        LEFT JOIN
    staffs T2 ON T2.userId = T1.personToMeetId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    staffs entryBy ON entryBy.userId = T1.entryBy
        LEFT JOIN
    persons ent ON ent.id = entryBy.personId
    LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams) 
UNION SELECT 
    T1.id AS ID,
    T3.emailId AS EMAIL_ID,
    T3.mobileCountryCode AS MOBILE_CODE,
    T3.mobileNumber AS MOBILE_NO,
    T3.firstName AS FIRST_NAME,
    T3.lastName AS LAST_NAME,
    T3.printName AS PRINT_NAME,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.expectedOutTime, '%h:%i %p') AS OUT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    ent.printName AS CREATED_PRINT_NAME,
    ent.firstName AS CREATED_FIRST_NAME,
    ent.lastName AS CREATED_LAST_NAME,
	TRIM(substring_index(appointeeName, '/', -1)) AS APPOINTEE_NAME,
    ml.code as LANGUAGE_KEY
FROM
    `sg_appointment` T1
        LEFT JOIN
    staffs T2 ON T2.userId = T1.personToMeetId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    students entryBy ON entryBy.userId = T1.entryBy
        LEFT JOIN
    persons ent ON ent.id = entryBy.personId
    LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@personToMeetApp; 


  -- PLACEMENT_JOB_POSTING
   
SET @plcmtJobPosting=(SELECT id FROM dtprovider WHERE `dataProviderName`='PLACEMENT_JOB_POSTING_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    pjs.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    u.code AS CORDINATOR_CODE,
    u.firstName AS CORDINATOR_FIRST_NAME,
    u.middleName AS CORDINATOR_MIDDLE_NAME,
    u.lastName AS CORDINATOR_LAST_NAME,
    pj.description AS DESCRIPTION,
	pj.jobTitle as JOB_TITLE,
    recruitingal.academyName AS ACADEMY_NAME,
    recruitingal.locationName AS LOCATION_NAME,
    recruitingal.displayName AS ACADEMY_NAME_LOCATION,
    orgal.displayName AS ORG_ACADEMY_NAME_LOCATION,
    DATE_FORMAT(pj.dateFrom, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(pj.dateTo, '%d-%m-%Y') AS TO_DATE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    placement_job_student pjs
        INNER JOIN
    placement_job pj ON pj.id = pjs.placementJobId
        LEFT JOIN
    placement_campus pc ON pc.id = pj.placementCampusId
        LEFT JOIN
    placement_campus_period pcp ON pcp.placementCampusId = pc.id
        LEFT JOIN
    students s ON s.userId = pjs.studentId
        LEFT JOIN
    persons AS p ON p.id = s.personId
        LEFT JOIN
    academy_location recruitingal ON recruitingal.id = pj.recruitingOrganizationId
        LEFT JOIN
    academy_location orgal ON orgal.id = pc.organizingAcademyLocationId
        LEFT JOIN
    users u ON u.id = pj.coordinatorId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
    LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE
    pjs.id IN (namedParams)
GROUP BY pjs.id" WHERE `dataProviderId`=@plcmtJobPosting; 
 
 
 -- CLINIC_APPOINTMENT ---1
   
SET @clinicAppntmnt=(SELECT id FROM dtprovider WHERE `dataProviderName`='CLINIC_APPOINTMENT_FACULTY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    autPer.`firstName` AS FIRST_NAME,
    autPer.`lastName` AS LAST_NAME,
    autPer.printName AS PRINT_NAME,
    autPer.`emailId` AS EMAIL_ID,
    autPer.`mobileNumber` AS MOBILE_NO,
    doc.printName AS DOC_PRINT_NAME,
    doc.firstName AS DOC_FIRST_NAME,
    doc.lastName AS DOC_LAST_NAME,
    stu.printName AS STUDENT_PRINT_NAME,
    stu.firstName AS STUDENT_FIRST_NAME,
    stu.lastName AS STUDENT_LAST_NAME,
	T2.sectionCode AS SECTION_CODE,
    ml.code as LANGUAGE_KEY,
	infRes.itemValue AS REASON,
    DATE_FORMAT(T1.infirmaryDate, '%d-%m-%Y') AS VISIT_DATE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where s.userId = f.userId)  AS DEVICE_ID,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL
FROM
    infirmary_details T1
        LEFT JOIN
    sections T2 ON T2.id = T1.sectionId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    users doc ON doc.id = T1.doctorUserId
        LEFT JOIN
    users authority ON authority.id = T1.authorityUserId
        LEFT JOIN
    staffs s ON s.userId = authority.id
        LEFT JOIN
    persons autPer ON autPer.id = s.personId
        LEFT JOIN
    users stu ON stu.id = T1.userId
 		LEFT JOIN
    infirmary_reason infRes on infRes.id = T1.infirmaryReasonId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
         LEFT JOIN
    multi_language ml on autPer.correspondence_language=ml.id
WHERE
    T1.id IN (namedParams) and T1.type = 'CLINIC'" WHERE `dataProviderId`=@clinicAppntmnt; 
 
   -- CLINIC_APPOINTMENT ---2
   
SET @clinicAppntmnt2=(SELECT id FROM dtprovider WHERE `dataProviderName`='CLINIC_APPOINTMENT_PARENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    pid.id AS ID,
    perPer.`firstName` AS FIRST_NAME,
    perPer.`lastName` AS LAST_NAME,
    perPer.printName AS PRINT_NAME,
    perPer.`emailId` AS EMAIL_ID,
    perPer.`mobileNumber` AS MOBILE_NO,
    doc.printName AS DOC_PRINT_NAME,
    doc.firstName AS DOC_FIRST_NAME,
    doc.lastName AS DOC_LAST_NAME,
    stu.printName AS STUDENT_PRINT_NAME,
    stu.firstName AS STUDENT_FIRST_NAME,
    stu.lastName AS STUDENT_LAST_NAME,
    T2.sectionCode AS SECTION_CODE,
    infRes.itemValue AS REASON,
    DATE_FORMAT(T1.infirmaryDate, '%d-%m-%Y') AS VISIT_DATE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    ml.code AS LANGUAGE_KEY,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info f
        WHERE
            parent.userId = f.userId) AS DEVICE_ID,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL
FROM
    infirmary_details T1
		INNER JOIN
    parent_infirmary_details pid ON pid.infirmaryId = T1.id
        LEFT JOIN
    sections T2 ON T2.id = T1.sectionId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    users doc ON doc.id = T1.doctorUserId        
        LEFT JOIN
    users stu ON stu.id = T1.userId
        LEFT JOIN
    infirmary_reason infRes ON infRes.id = T1.infirmaryReasonId        
		LEFT JOIN
    persons perPer ON perPer.id = pid.personId
        LEFT JOIN
    parents parent ON parent.personId = perPer.id
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT MAX(id) FROM organizations)
     
        INNER JOIN
   students st ON st.userId = stu.id
       INNER JOIN
   persons stuPer ON stuPer.id = st.personId
	LEFT JOIN
    multi_language ml on stuPer.correspondence_language = ml.id
WHERE
    pid.id IN (namedParams)
        AND T1.type = 'CLINIC'" WHERE `dataProviderId`=@clinicAppntmnt2; 
 
  -- INTERVENTION_APPOINTMENT ---1
   
SET @interventionAppntmnt=(SELECT id FROM dtprovider WHERE `dataProviderName`='INTERVENTION_APPOINTMENT_FACULTY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    autPer.`firstName` AS FIRST_NAME,
    autPer.`lastName` AS LAST_NAME,
    autPer.printName AS PRINT_NAME,
    autPer.`emailId` AS EMAIL_ID,
    autPer.`mobileNumber` AS MOBILE_NO,
    doc.printName AS DOC_PRINT_NAME,
    doc.firstName AS DOC_FIRST_NAME,
    doc.lastName AS DOC_LAST_NAME,
    stu.printName AS STUDENT_PRINT_NAME,
    stu.firstName AS STUDENT_FIRST_NAME,
    stu.lastName AS STUDENT_LAST_NAME,
	T2.sectionCode AS SECTION_CODE,
	infRes.itemValue AS REASON,
    DATE_FORMAT(T1.infirmaryDate, '%d-%m-%Y') AS VISIT_DATE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where s.userId = f.userId)  AS DEVICE_ID,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL
FROM
    infirmary_details T1
        LEFT JOIN
    sections T2 ON T2.id = T1.sectionId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    users doc ON doc.id = T1.doctorUserId
        LEFT JOIN
    users authority ON authority.id = T1.authorityUserId
        LEFT JOIN
    staffs s ON s.userId = authority.id
        LEFT JOIN
    persons autPer ON autPer.id = s.personId
        LEFT JOIN
    users stu ON stu.id = T1.userId
 		LEFT JOIN
    infirmary_reason infRes on infRes.id = T1.infirmaryReasonId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
     LEFT JOIN
	multi_language ml on ml.id=autPer.correspondence_language       
WHERE
    T1.id IN (namedParams) and T1.type = 'INTERVENTION'" WHERE `dataProviderId`=@interventionAppntmnt; 
 
   -- INTERVENTION_APPOINTMENT ---2
   
SET @interventionAppntmnt2=(SELECT id FROM dtprovider WHERE `dataProviderName`='INTERVENTION_APPOINTMENT_PARENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    pid.id AS ID,
    perPer.`firstName` AS FIRST_NAME,
    perPer.`lastName` AS LAST_NAME,
    perPer.printName AS PRINT_NAME,
    perPer.`emailId` AS EMAIL_ID,
    perPer.`mobileNumber` AS MOBILE_NO,
    doc.printName AS DOC_PRINT_NAME,
    doc.firstName AS DOC_FIRST_NAME,
    doc.lastName AS DOC_LAST_NAME,
    stu.printName AS STUDENT_PRINT_NAME,
    stu.firstName AS STUDENT_FIRST_NAME,
    stu.lastName AS STUDENT_LAST_NAME,
    T2.sectionCode AS SECTION_CODE,
    infRes.itemValue AS REASON,
    DATE_FORMAT(T1.infirmaryDate, '%d-%m-%Y') AS VISIT_DATE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info f
        WHERE
            parent.userId = f.userId) AS DEVICE_ID,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL
FROM
    infirmary_details T1
        INNER JOIN
    parent_infirmary_details pid ON pid.infirmaryId = T1.id
        LEFT JOIN
    sections T2 ON T2.id = T1.sectionId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    users doc ON doc.id = T1.doctorUserId
        LEFT JOIN
    persons perPer ON perPer.id = pid.personId
        LEFT JOIN
    parents parent ON parent.personId = perPer.id
        LEFT JOIN
    users stu ON stu.id = T1.userId
        LEFT JOIN
    infirmary_reason infRes ON infRes.id = T1.infirmaryReasonId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT MAX(id) FROM organizations)
        LEFT JOIN
	multi_language ml on ml.id=perPer.correspondence_language
WHERE
    pid.id IN (namedParams)
        AND T1.type = 'INTERVENTION'" WHERE `dataProviderId`=@interventionAppntmnt2; 

   -- STUDENT_HOSTEL_LEAVE_APPROVE 
   
SET @stndHtslLvApp=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_HOSTEL_LEAVE_APPROVE_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T11.firstName AS FIRST_NAME,
    T11.middleName AS MIDDLE_NAME,
    T11.lastName AS LAST_NAME,
    T11.emailId AS EMAIL_ID,
    T11.mobileNumber AS MOBILE_NO,
    T11.mobileCountryCode AS MOBILE_CODE,
    T2.requestId AS REQUEST_ID,
    T9.firstName AS RESPONSIBLE_PER_FIRST_NAME,
    T9.middleName AS RESPONSIBLE_PER_MIDDLE_NAME,
	T9.lastName AS RESPONSIBLE_PER_LAST_NAME,
    T15.nameToBePrinted AS HOSTEL_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T12.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T12.footerUrl)
        else NULL 
    end) as FOOTER_URL 
FROM
    service_requests AS T2
        INNER JOIN
    hostel_leave_service_request_details AS T3 ON T3.serviceRequestId = T2.id
        INNER JOIN
    hostel_room_allotment AS T4 ON T4.id = T3.roomAllotmentId
        INNER JOIN
    hostel_room AS T5 ON T5.id = T4.roomId
        LEFT JOIN
    hostel_floor AS T6 ON T6.id = T5.floorId
        LEFT JOIN
    hostel_building AS T7 ON T7.id = T6.buildinglId
        LEFT JOIN
    hostel AS T8 ON T8.id = T7.hostelId
        LEFT JOIN
    users AS T9 ON T9.id = T8.wardenId
        INNER JOIN
    students AS T10 ON T10.userId = T4.studentId
        INNER JOIN
    persons AS T11 ON T11.id = T10.personId
		LEFT OUTER JOIN
    resources T15 ON T15.id = T8.resourceId
		LEFT OUTER JOIN
    resource_academy_locations T14 ON T14.resourceId = T8.resourceId
		LEFT OUTER JOIN
    academy_location T12 ON T12.id = T14.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
     LEFT JOIN
	multi_language ml on ml.id=T11.correspondence_language         
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@stndHtslLvApp; 
 
    -- STUDENT_HOSTEL_LEAVE_REJECT_REJECT 
   
SET @stndHtslLvRej=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_HOSTEL_LEAVE_REJECT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T11.firstName AS FIRST_NAME,
    T11.middleName AS MIDDLE_NAME,
    T11.lastName AS LAST_NAME,
    T11.emailId AS EMAIL_ID,
    T11.mobileNumber AS MOBILE_NO,
    T11.mobileCountryCode AS MOBILE_CODE,
    T2.requestId AS REQUEST_ID,
    T9.firstName AS RESPONSIBLE_PER_FIRST_NAME,
    T9.middleName AS RESPONSIBLE_PER_MIDDLE_NAME,
	T9.lastName AS RESPONSIBLE_PER_LAST_NAME,
    T15.nameToBePrinted AS HOSTEL_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T12.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T12.footerUrl)
        else NULL 
    end) as FOOTER_URL 
FROM
    service_requests AS T2
        INNER JOIN
    hostel_leave_service_request_details AS T3 ON T3.serviceRequestId = T2.id
        INNER JOIN
    hostel_room_allotment AS T4 ON T4.id = T3.roomAllotmentId
        INNER JOIN
    hostel_room AS T5 ON T5.id = T4.roomId
        LEFT JOIN
    hostel_floor AS T6 ON T6.id = T5.floorId
        LEFT JOIN
    hostel_building AS T7 ON T7.id = T6.buildinglId
        LEFT JOIN
    hostel AS T8 ON T8.id = T7.hostelId
        LEFT JOIN
    users AS T9 ON T9.id = T8.wardenId
        INNER JOIN
    students AS T10 ON T10.userId = T4.studentId
        INNER JOIN
    persons AS T11 ON T11.id = T10.personId
		LEFT OUTER JOIN
    resources T15 ON T15.id = T8.resourceId
		LEFT OUTER JOIN
    resource_academy_locations T14 ON T14.resourceId = T8.resourceId
		LEFT OUTER JOIN
    academy_location T12 ON T12.id = T14.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
         LEFT JOIN
	multi_language ml on ml.id=T11.correspondence_language       
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@stndHtslLvRej; 
 
     -- LEAVE_WORK_HAND_OVER 
   
SET @leaveWrkHndOvr=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_WORK_HAND_OVER_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T6.id AS ID,
    requester.emailId AS EMAIL_ID,
    requester.mobileNumber AS MOBILE_NO,
    requester.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS PRINT_NAME,
    requester.firstName AS FIRST_NAME,
    requester.lastName AS LAST_NAME,
    reqUser.code AS CODE,
    T5.salutationName AS SALUTATION_NAME,
    T10.printName AS REQ_PRINT_NAME,
    T11.code AS REQ_CODE,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.id AS ACADEMY_LOCATION_ID,
    ml.code as LANGUAGE_KEY,
    DATE_FORMAT(T1.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.toDate, '%d-%m-%Y') AS TO_DATE,
    (CASE WHEN T8.logoUrl IS NULL AND org.orgUrl IS NOT NULL
        THEN CONCAT(org.orgUrl,'/', 'emailer/images/logo_default_image.png')
        WHEN T8.logoUrl IS NULL AND org.orgUrl IS NULL
        THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl) END) AS LOGO_URL,
    (CASE WHEN T8.headerUrl IS NOT NULL AND org.orgUrl IS NOT NULL
        THEN CONCAT(org.orgUrl, '/', T8.headerUrl) ELSE NULL END) AS HEADER_URL,
    (CASE WHEN T8.footerUrl IS NOT NULL AND org.orgUrl IS NOT NULL
        THEN CONCAT(org.orgUrl, '/', T8.footerUrl)
        ELSE NULL END) AS FOOTER_URL
FROM
    hr_emp_leave_request_handover_user AS T6
        LEFT JOIN
    hr_emp_leave_request AS T1 ON T1.id = T6.hrEmpLeaveRequestId
        LEFT JOIN
    staffs AS T3 ON T3.userId = T6.userId
        LEFT JOIN
    persons AS requester ON requester.id = T3.personId
        LEFT JOIN
    salutations AS T5 ON T5.id = requester.salutationId
        LEFT JOIN
    users AS reqUser ON reqUser.id = T3.userId
        LEFT JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    staffs AS T9 ON T9.userId = T1.requestUserId
        LEFT JOIN
    persons AS T10 ON T10.id = T9.personId
        LEFT JOIN
    users AS T11 ON T11.id = T9.userId
		LEFT JOIN
    organizations org ON org.id = (SELECT MAX(org.id))
    LEFT JOIN
	multi_language ml on ml.id=requester.correspondence_language
WHERE
    T6.id IN (namedParams)" WHERE `dataProviderId`=@leaveWrkHndOvr; 
    
     -- SR_LEAVE_INTIMATION ---1
   
SET @srleaveEstmtn=(SELECT id FROM dtprovider WHERE `dataProviderName`='SR_LEAVE_ASSIGNEE_INTIMATION_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T1.requestId AS REQUEST_ID,
    T6.printName AS STUDENT_PRINT_NAME,
    T6.firstName AS STUDENT_FIRST_NAME,
    T6.middleName AS STUDENT_MIDDLE_NAME,
    T6.lastName AS STUDENT_LAST_NAME,
    T3.emailId AS EMAIL_ID,
    T3.mobileNumber AS MOBILE_NO,
    T3.mobileCountryCode AS MOBILE_CODE,
    T3.printName AS PRINT_NAME,
    T3.firstName AS FIRST_NAME,
    T3.middleName AS MIDDLE_NAME,
    T3.lastName AS LAST_NAME,
    T4.salutationName AS SALUTATION_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T12.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
	(CASE
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T12.logoUrl)
    END) AS LOGO_URL
FROM
    service_requests AS T1
        LEFT JOIN
    service_request_settings T7 ON T7.id = T1.serviceRequestSettingId
        INNER JOIN
    staffs AS T2 ON T2.userId = T1.assigneeId
        LEFT JOIN
    persons AS T3 ON T3.id = T2.personId
        LEFT JOIN
    salutations AS T4 ON T4.id = T3.salutationId
        LEFT JOIN
    students AS T5 ON T5.userId = T1.requester
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT OUTER JOIN
    academy_location T12 ON T12.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
    LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language        
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@srleaveEstmtn;     
 
      -- SR_LEAVE_INTIMATION ---2
   
SET @srleaveEstmtn2=(SELECT id FROM dtprovider WHERE `dataProviderName`='SR_LEAVE_STUDENT_INTIMATION_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T1.requestId AS REQUEST_ID,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
    T6.printName AS PRINT_NAME,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T12.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
	(CASE
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T12.logoUrl)
    END) AS LOGO_URL
FROM
    service_requests AS T1
        LEFT JOIN
    service_request_settings T7 ON T7.id = T1.serviceRequestSettingId
        INNER JOIN
    students AS T5 ON T5.userId = T1.requester
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT OUTER JOIN
    academy_location T12 ON T12.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
    LEFT JOIN
	multi_language ml on ml.id=T6.correspondence_language        
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@srleaveEstmtn2; 
 
       -- SHARE_FOLDER
   
SET @shareFolder=(SELECT id FROM dtprovider WHERE `dataProviderName`='SHARE_FOLDER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.code AS CODE,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
    T2.albumName AS ALBUM_NAME,
    T2.description AS ALBUM_DESCRIPTION,
    T4.code AS CREATED_CODE,
    T4.firstName AS CREATED_FIRST_NAME,
    T4.middleName AS CREATED_MIDDLE_NAME,
    T4.lastName AS CREATED_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    gallery_users T1
        LEFT JOIN
    gallery T2 ON T2.id = T1.galleryId
        LEFT JOIN
    users T3 ON T3.id = T1.userId
        INNER JOIN
    students AS T5 ON T5.userId = T3.id
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT JOIN
    users T4 ON T4.id = T2.createdBy
    LEFT JOIN
	multi_language ml on ml.id=T6.correspondence_language
WHERE
    T1.id IN (namedParams) 
UNION SELECT 
    T1.id AS ID,
    T3.code AS CODE,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
    T2.albumName AS ALBUM_NAME,
    T2.description AS ALBUM_DESCRIPTION,
    T4.code AS CREATED_CODE,
    T4.firstName AS CREATED_FIRST_NAME,
    T4.middleName AS CREATED_MIDDLE_NAME,
    T4.lastName AS CREATED_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    gallery_users T1
        LEFT JOIN
    gallery T2 ON T2.id = T1.galleryId
        LEFT JOIN
    users T3 ON T3.id = T1.userId
        INNER JOIN
    staffs AS T5 ON T5.userId = T3.id
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT JOIN
    users T4 ON T4.id = T2.createdBy
    LEFT JOIN
	multi_language ml on ml.id=T6.correspondence_language
WHERE
    T1.id IN (namedParams) 
UNION SELECT 
    T1.id AS ID,
    T3.code AS CODE,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
    T2.albumName AS ALBUM_NAME,
    T2.description AS ALBUM_DESCRIPTION,
    T4.code AS CREATED_CODE,
    T4.firstName AS CREATED_FIRST_NAME,
    T4.middleName AS CREATED_MIDDLE_NAME,
    T4.lastName AS CREATED_LAST_NAME,
    ml.code as LANGUAGE_KEY
FROM
    gallery_users T1
        LEFT JOIN
    gallery T2 ON T2.id = T1.galleryId
        LEFT JOIN
    users T3 ON T3.id = T1.userId
        INNER JOIN
    parents AS T5 ON T5.userId = T3.id
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT JOIN
    users T4 ON T4.id = T2.createdBy
    LEFT JOIN
	multi_language ml on ml.id=T6.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@shareFolder; 
 
        -- STUDENT_LEAVE_APPROVE
   
SET @studentLeave=(SELECT id FROM dtprovider WHERE `dataProviderName`='SR_STUDENT_LEAVE_APPROVE_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T1.requestId AS REQUEST_ID,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
    T6.printName AS PRINT_NAME,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T12.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
	(CASE
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T12.logoUrl)
    END) AS LOGO_URL
FROM
    service_requests AS T1
        LEFT JOIN
    service_request_settings T7 ON T7.id = T1.serviceRequestSettingId
        LEFT JOIN
    students AS T5 ON T5.userId = T1.requester
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT OUTER JOIN
    academy_location T12 ON T12.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
    LEFT JOIN
	multi_language ml on ml.id=T6.correspondence_language        
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@studentLeave; 
 
 
         -- STUDENT_LEAVE_REJECT
   
SET @studentLeaveRej=(SELECT id FROM dtprovider WHERE `dataProviderName`='SR_STUDENT_LEAVE_REJECT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T1.requestId AS REQUEST_ID,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
    T6.printName AS PRINT_NAME,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T12.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
	(CASE
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T12.logoUrl)
    END) AS LOGO_URL
FROM
    service_requests AS T1
        LEFT JOIN
    service_request_settings T7 ON T7.id = T1.serviceRequestSettingId
        LEFT JOIN
    students AS T5 ON T5.userId = T1.requester
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT OUTER JOIN
    academy_location T12 ON T12.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
    LEFT JOIN
	multi_language ml on ml.id=T6.correspondence_language        
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@studentLeaveRej; 
            
 set sql_safe_updates=1;

